/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.logging;

import com.bxm.warcar.logging.Logging;
import com.bxm.warcar.logging.LoggingWriter;
import com.bxm.warcar.logging.OperatorExtractor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class OncePerRequestLoggingFilter
extends OncePerRequestFilter {
    private static final int DEFAULT_PAYLOAD_MAX_LENGTH = 1024;
    private final String applicationId;
    private final int payloadMaxLength;
    private final LoggingWriter loggingWriter;
    private final OperatorExtractor operatorExtractor;
    private List<String> excludeRequestUriPrefix;
    private Set<String> excludeRequestMethod;

    public OncePerRequestLoggingFilter(String applicationId, OperatorExtractor operatorExtractor) {
        this(applicationId, 1024, new LoggingWriter(){}, operatorExtractor);
    }

    public OncePerRequestLoggingFilter(String applicationId, int payloadMaxLength, LoggingWriter loggingWriter, OperatorExtractor operatorExtractor) {
        this.applicationId = applicationId;
        this.payloadMaxLength = payloadMaxLength;
        this.loggingWriter = loggingWriter;
        this.operatorExtractor = operatorExtractor;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String requestUri = request.getRequestURI();
        if (CollectionUtils.isNotEmpty(this.excludeRequestUriPrefix) && this.excludeRequestUriPrefix.stream().anyMatch(e -> StringUtils.startsWithIgnoreCase((String)requestUri, (String)e))) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String method = request.getMethod();
        if (CollectionUtils.isNotEmpty(this.excludeRequestMethod) && this.excludeRequestMethod.stream().anyMatch(e -> StringUtils.equalsIgnoreCase((String)method, (String)e))) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        long startTime = System.currentTimeMillis();
        ContentCachingRequestWrapper requestWrapper = new ContentCachingRequestWrapper(request);
        ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper(response);
        try {
            filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            this.doLog(startTime, requestWrapper, responseWrapper, null, true);
        }
        catch (Exception e2) {
            this.doLog(startTime, requestWrapper, responseWrapper, e2.getMessage(), false);
            throw e2;
        }
        finally {
            responseWrapper.copyBodyToResponse();
        }
    }

    private void doLog(long startTime, ContentCachingRequestWrapper requestWrapper, ContentCachingResponseWrapper responseWrapper, String throwable, boolean success) {
        String requestPayload = this.convert2String(requestWrapper.getContentAsByteArray(), requestWrapper.getCharacterEncoding());
        String responsePayload = this.convert2String(responseWrapper.getContentAsByteArray(), responseWrapper.getCharacterEncoding());
        if (null != this.loggingWriter) {
            String operator = this.extractOperator((HttpServletRequest)requestWrapper);
            int sc = responseWrapper.getStatusCode();
            this.loggingWriter.write(Logging.build(this.applicationId, (HttpServletRequest)requestWrapper, startTime, requestPayload, responsePayload, sc, success, throwable, operator));
        }
    }

    private String extractOperator(HttpServletRequest request) {
        if (null != this.operatorExtractor) {
            try {
                return this.operatorExtractor.extract(request);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String convert2String(byte[] buffer, String characterEncoding) {
        if (ArrayUtils.isEmpty((byte[])buffer)) {
            return null;
        }
        int len = buffer.length;
        if (len > 0) {
            int maxLength = Math.min(len, this.getPayloadMaxLength());
            try {
                return new String(buffer, 0, maxLength, characterEncoding);
            }
            catch (UnsupportedEncodingException ex) {
                return "[unknown data packet length is " + len + "]";
            }
        }
        return null;
    }

    public int getPayloadMaxLength() {
        return this.payloadMaxLength;
    }

    public LoggingWriter getLoggingWriter() {
        return this.loggingWriter;
    }

    public List<String> getExcludeRequestUriPrefix() {
        return this.excludeRequestUriPrefix;
    }

    public void setExcludeRequestUriPrefix(List<String> excludeRequestUriPrefix) {
        this.excludeRequestUriPrefix = excludeRequestUriPrefix;
    }

    public Set<String> getExcludeRequestMethod() {
        return this.excludeRequestMethod;
    }

    public void setExcludeRequestMethod(Set<String> excludeRequestMethod) {
        this.excludeRequestMethod = excludeRequestMethod;
    }
}

