/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.message.dingding;

import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.utils.JsonHelper;
import java.io.Serializable;
import java.util.HashMap;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DingDingMessageSender
implements MessageSender {
    private final String url;

    public DingDingMessageSender(String url) {
        this.url = url;
    }

    @Override
    public boolean send(Message message) {
        JSONObject jsonParam = new JSONObject();
        HashMap<String, String> text = new HashMap<String, String>();
        text.put("content", message.getContent());
        HashMap<String, Object> at = new HashMap<String, Object>();
        at.put("atMobiles", message.getTos());
        at.put("isAtAll", false);
        jsonParam.put("msgtype", (Object)"text");
        jsonParam.put("text", text);
        jsonParam.put("at", at);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json; charset=UTF-8");
        HttpEntity req = new HttpEntity((Object)jsonParam.toJSONString(), (MultiValueMap)headers);
        RestTemplate rest = new RestTemplate();
        ResponseEntity responseEntity = rest.postForEntity(this.url, (Object)req, String.class, new Object[0]);
        SendResult body = (SendResult)JsonHelper.convert((String)((String)responseEntity.getBody()), SendResult.class);
        return null != body && body.isSucceed();
    }

    public static class SendResult
    implements Serializable {
        private static final long serialVersionUID = -9083143317071986607L;
        private int errcode = -1;
        private String errmsg;

        public boolean isSucceed() {
            return this.errcode == 0;
        }

        public int getErrcode() {
            return this.errcode;
        }

        public void setErrcode(int errcode) {
            this.errcode = errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }
    }
}

