package com.bxm.warcar.voice.submail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.AbstractMessageSender;
import com.bxm.warcar.MessageException;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.http.ResponseEntity;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <h3>发送语音验证</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/02/12 10:58
 */
public class SubmailSmsVoiceSender extends AbstractMessageSender implements VoiceSender {

    private static final String SUCCESS = "success";
    private final String appid;
    private final String appkey;
    private final String url;
    private final String project;

    public SubmailSmsVoiceSender(String appid, String appkey, String url,  String project) {
        this.appid = appid;
        this.appkey = appkey;
        this.url = url;
        this.project = project;
    }


    @Override
    public void send(Voice voice) throws MessageException {
        JSONObject jsonParam = new JSONObject();
        jsonParam.put("appid", appid);
        jsonParam.put("multi", JSON.toJSONString(voice.getMulti()));
        jsonParam.put("signature", appkey);
        jsonParam.put("project",project);

        ResponseEntity<String> responseEntity = postForEntity(url, jsonParam);
        List<SendResult> bodys = JSONObject.parseArray(responseEntity.getBody(),SendResult.class);
        if (CollectionUtils.isEmpty(bodys)) {
            throw new MessageException("result is null!");
        }

        for (SendResult body:bodys){
            if (!SUCCESS.equals(body.getStatus())) {
                throw new MessageException(JSONObject.toJSONString(body), body.getStatus());
            }
        }

    }

    public static class SendResult implements Serializable {

        private static final long serialVersionUID = -9083143317071986607L;
        private String status;
        private String to;
        private String send_id;
        private String money_account;

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getTo() {
            return to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String getSend_id() {
            return send_id;
        }

        public void setSend_id(String send_id) {
            this.send_id = send_id;
        }

        public String getMoney_account() {
            return money_account;
        }

        public void setMoney_account(String money_account) {
            this.money_account = money_account;
        }
    }

    public static void main(String[] args) {
        VoiceSender sender = new SubmailSmsVoiceSender("21117",
                "847ebe942e6799deea966ff854c3d28f",
                "https://api.mysubmail.com/voice/multixsend.json",
                "TOi1t1");
        Voice voice= new Voice();
        Map<String, String> vars = Maps.newHashMap();
        vars.put("name", "Auto-ChatGPT");
        voice.addMulti("18069422242", vars);
        sender.send(voice);
    }
}
