/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.message.sms.submail;

import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.AbstractMessageSender;
import com.bxm.warcar.MessageException;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import org.springframework.http.ResponseEntity;

public class SubmailSmsMessageSender
extends AbstractMessageSender
implements MessageSender {
    private static final String SUCCESS = "success";
    private final String appid;
    private final String appkey;
    private final String url;

    public SubmailSmsMessageSender(String appid, String appkey, String url) {
        this.appid = appid;
        this.appkey = appkey;
        this.url = url;
    }

    @Override
    public boolean send(Message message) {
        try {
            this.send2(message);
            return true;
        }
        catch (MessageException e) {
            return false;
        }
    }

    @Override
    public void send2(Message message) throws MessageException {
        JSONObject jsonParam = new JSONObject();
        jsonParam.put("appid", (Object)this.appid);
        jsonParam.put("to", (Object)message.getTos().get(0));
        jsonParam.put("content", (Object)message.getContent());
        jsonParam.put("signature", (Object)this.appkey);
        ResponseEntity<String> responseEntity = this.postForEntity(this.url, jsonParam);
        SendResult body = (SendResult)JsonHelper.convert((String)((String)responseEntity.getBody()), SendResult.class);
        if (null == body) {
            throw new MessageException("result is null!");
        }
        if (!SUCCESS.equals(body.getStatus())) {
            throw new MessageException(JSONObject.toJSONString((Object)body), body.getStatus());
        }
    }

    public static void main(String[] args) {
        SubmailSmsMessageSender sender = new SubmailSmsMessageSender("25693", "8c994cfb981f30e864a04a1f1fd6eae2", "https://api.mysubmail.com/message/send.json");
        try {
            sender.send2(new Message("\u301033\u5143/\u74f6 53\u5ea6\u91e3\u81fa\u516c\u9152\u3011\u7ebf\u4e0a\u62a5\u8b66\uff1aJava (pangu) \u7a0b\u5e8f\u5f53\u524d\u79bb\u7ebf\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002", Lists.newArrayList((Object[])new String[]{"17674750075"})));
        }
        catch (MessageException e) {
            e.printStackTrace();
        }
    }

    public static class SendResult
    implements Serializable {
        private static final long serialVersionUID = -9083143317071986607L;
        private String status;
        private String send_id;
        private int fee;
        private String sms_credits;
        private String transactional_sms_credits;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getSend_id() {
            return this.send_id;
        }

        public void setSend_id(String send_id) {
            this.send_id = send_id;
        }

        public int getFee() {
            return this.fee;
        }

        public void setFee(int fee) {
            this.fee = fee;
        }

        public String getSms_credits() {
            return this.sms_credits;
        }

        public void setSms_credits(String sms_credits) {
            this.sms_credits = sms_credits;
        }

        public String getTransactional_sms_credits() {
            return this.transactional_sms_credits;
        }

        public void setTransactional_sms_credits(String transactional_sms_credits) {
            this.transactional_sms_credits = transactional_sms_credits;
        }
    }
}

