package com.bxm.warcar.metrics;

import org.springframework.boot.actuate.metrics.CounterService;

import java.util.concurrent.ConcurrentHashMap;

/**
 * @author allen
 * @since 1.0.0
 */
public class DefaultCounterMetric implements CounterMetric {

    private final CounterService counterService;

    private final ConcurrentHashMap<String, String> names = new ConcurrentHashMap<String, String>();

    public DefaultCounterMetric(CounterService counterService) {
        this.counterService = counterService;
    }

    @Override
    public void increment(String metricName) {
        counterService.increment(metricName);
    }

    @Override
    public void decrement(String metricName) {
        counterService.decrement(metricName);
    }

    @Override
    public void reset(String metricName) {
        counterService.reset(metricName);
    }
}
