/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.micrometer.integration.eventbus;

import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.micrometer.integration.eventbus.EventListenerMeter;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class EventListenerMeterAspect {
    private final EventListenerMeter eventListenerMeter;

    public EventListenerMeterAspect(EventListenerMeter eventListenerMeter) {
        this.eventListenerMeter = eventListenerMeter;
    }

    @Pointcut(value="@annotation(com.bxm.warcar.integration.eventbus.core.Subscribe)")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof EventListener)) {
            return point.proceed();
        }
        EventListener eventListener = (EventListener)target;
        Timer timer = this.eventListenerMeter.getTimer(eventListener);
        long start = System.nanoTime();
        try {
            Object object = point.proceed();
            return object;
        }
        finally {
            timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

