package com.bxm.warcar.micrometer.sentinel;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;

/**
 * @author allen
 * @date 2022-03-30
 * @since 1.0
 */
public class SentinelMeter implements MeterBinder {

    private static MeterRegistry registry;
    private static double[] rtTimerPercentiles;

    public SentinelMeter(double[] rtTimerPercentiles) {
        SentinelMeter.rtTimerPercentiles = rtTimerPercentiles;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        SentinelMeter.registry = registry;
    }

    static void counter(String name, int n, String... tags) {
        if (Objects.nonNull(registry)) {
            registry.counter(name, tags).increment(n);
        }
    }

    static void timer(String name, long rt, String... tags) {
        if (Objects.nonNull(registry)) {
            Timer.builder(name).tags(tags).publishPercentiles(rtTimerPercentiles).register(registry).record(rt, TimeUnit.MILLISECONDS);
        }
    }

    static void gauge(String name, Iterable<Tag> tags, ToDoubleFunction<Long> valueFunction) {
        if (Objects.nonNull(registry)) {
            registry.gauge(name, tags, 0L, valueFunction);
        }
    }
}
