package com.bxm.warcar.micrometer.integration.dot;

import com.bxm.warcar.integration.dc.dot.AsyncDot;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;

import java.util.Map;

/**
 * @author allen
 * @date 2019/8/29
 * @since 1.0.0
 */
public class AsyncDotMeter implements MeterBinder {

    private final Map<String, AsyncDot> beans;

    public AsyncDotMeter(Map<String, AsyncDot> dotMap) {
        this.beans = dotMap;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        for (Map.Entry<String, AsyncDot> entry : beans.entrySet()) {
            String name = entry.getKey();
            AsyncDot asyncDot = entry.getValue();
            Gauge.builder("warcar.integration.dot.core", 0, value -> asyncDot.getCorePoolSize()).tags("name", name).register(registry);
            Gauge.builder("warcar.integration.dot.queue", 0, value -> asyncDot.getQueueSize()).tags("name", name).register(registry);
            Gauge.builder("warcar.integration.dot.active", 0, value -> asyncDot.getActiveCount()).tags("name", name).register(registry);
        }
    }
}
