/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.micrometer.mq;

import com.bxm.warcar.micrometer.mq.ProducerMeter;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.Type;
import io.micrometer.core.instrument.Timer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class ProducerMeterAspect {
    private final ProducerMeter producerMeter;

    public ProducerMeterAspect(ProducerMeter producerMeter) {
        this.producerMeter = producerMeter;
    }

    @Pointcut(value="this(com.bxm.warcar.mq.Producer)")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof Producer)) {
            return point.proceed();
        }
        Type type = ((Producer)target).getType();
        Timer timer = this.producerMeter.getTimer(type);
        long start = System.nanoTime();
        try {
            Object object = point.proceed();
            return object;
        }
        finally {
            if (Objects.nonNull(timer)) {
                timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
    }
}

