/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.micrometer.ip;

import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.utils.MapHelper;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.springframework.util.ClassUtils;

public class IpLibraryMeter
implements MeterBinder {
    private final Map<String, Timer> timer = Maps.newHashMap();
    private final Map<String, Gauge> gauge = Maps.newHashMap();
    private final Map<String, AtomicLong> total = Maps.newHashMap();
    private final Map<String, AtomicLong> success = Maps.newHashMap();
    private final Iterable<IpLibrary> ipLibraryIterator;

    public IpLibraryMeter(Iterable<IpLibrary> ipLibraryIterator) {
        this.ipLibraryIterator = ipLibraryIterator;
    }

    public void bindTo(MeterRegistry registry) {
        this.ipLibraryIterator.forEach(e -> {
            final String simpleName = this.getSimpleName((IpLibrary)e);
            this.timer.put(simpleName, Timer.builder((String)"warcar.iplibrary.time").tags(new String[]{"name", simpleName}).register(registry));
            Gauge.builder((String)"warcar.iplibrary.gauge", (Supplier)new Supplier<Number>(){

                @Override
                public Number get() {
                    AtomicLong t = (AtomicLong)IpLibraryMeter.this.total.get(simpleName);
                    AtomicLong s = (AtomicLong)IpLibraryMeter.this.success.get(simpleName);
                    if (Objects.isNull(t)) {
                        return 0L;
                    }
                    return new BigDecimal(Optional.ofNullable(s).orElse(new AtomicLong(0L)).get()).divide(BigDecimal.valueOf(t.get()), 3, RoundingMode.HALF_UP);
                }
            }).tags(new String[]{"name", simpleName}).register(registry);
        });
    }

    private String getSimpleName(IpLibrary e) {
        return ClassUtils.getUserClass((Object)e).getSimpleName();
    }

    Timer getTimer(IpLibrary instance) {
        return this.timer.get(this.getSimpleName(instance));
    }

    void incrementSuccess(IpLibrary e) {
        ((AtomicLong)MapHelper.get(this.success, (Object)this.getSimpleName(e), (Object)new AtomicLong(0L))).incrementAndGet();
    }

    void incrementTotal(IpLibrary e) {
        ((AtomicLong)MapHelper.get(this.total, (Object)this.getSimpleName(e), (Object)new AtomicLong(0L))).incrementAndGet();
    }
}

