package com.bxm.warcar.micrometer.mq;

import com.bxm.warcar.mq.Type;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;

import java.util.Map;

/**
 * @author allen
 * @date 2019/6/18
 * @since 1.0.0
 */
public class ProducerMeter implements MeterBinder {

    private final Map<Type, Timer> timer = Maps.newHashMap();

    @Override
    public void bindTo(MeterRegistry registry) {
        for (Type type : Type.values()) {
            timer.put(type, Timer.builder("warcar.mq.producer").tags("type", type.name()).register(registry));
        }
    }

    Timer getTimer(Type type) {
        return this.timer.get(type);
    }
}
