/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq;

import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.Type;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;

public class ProducerFactory {
    private static final Map<Type, Producer> PRODUCERS = Maps.newConcurrentMap();

    public ProducerFactory(Map<Type, Producer> producers) {
        PRODUCERS.putAll(producers);
    }

    public static Producer getFirst() {
        Iterator<Map.Entry<Type, Producer>> iterator = PRODUCERS.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<Type, Producer> e = iterator.next();
            return e.getValue();
        }
        return null;
    }

    public static Producer getProducer(Type type) {
        return PRODUCERS.get((Object)type);
    }

    public static Producer getAlionsProducer() {
        return PRODUCERS.get((Object)Type.ALIONS);
    }

    public static Producer getRocketMQProducer() {
        return PRODUCERS.get((Object)Type.ROCKETMQ);
    }

    public static Producer getActiveMQProducer() {
        return PRODUCERS.get((Object)Type.ACTIVEMQ);
    }
}

