import com.bxm.warcar.utils.http.HttpClientUtils;
import com.google.common.collect.Maps;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * @author allen
 * @date 2020-09-18
 * @since 1.0
 */
public class QrCli {

    private static HttpClient httpClient = HttpClientBuilder.create().build();

    private static String getUrl(String machineId) throws IOException {
        Map<String, String> headers = Maps.newHashMap();
        headers.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.83 Safari/537.36");
        headers.put("Referer", "https://cli.im/url/info?e36f9f0994f2ac84578bed6213163ac2");

        String s = HttpClientUtils.get("https://qr.api.cli.im/newqr/createParam" +
                "?qrcodeconfig%5Bdata%5D=https%253A%252F%252Fpublic.ihibei.cn%252Facode%252F" + machineId + "&qrcodeconfig%5Bsize%5D=400&qrcodeconfig%5Blogourl%5D=&qrcodeconfig%5Blogoshape%5D=ellipse&qrcodeconfig%5Bforecolor%5D=&qrcodeconfig%5Beye_use_fore%5D=1&qrcodeconfig%5Bbgcolor%5D=%23FFFFFF&qrcodeconfig%5Bbackground%5D=images%2Fbackground%2Fbg12.png&qrcodeconfig%5Bwper%5D=0.74&qrcodeconfig%5Bhper%5D=0.74&qrcodeconfig%5Btper%5D=0.13&qrcodeconfig%5Blper%5D=0.13&qrcodeconfig%5Btransparent%5D=0&qrcodeconfig%5Bqrcode_eyes%5D=&qrcodeconfig%5Boutcolor%5D=&qrcodeconfig%5Bincolor%5D=&qrcodeconfig%5Bmarginblock%5D=2&qrcodeconfig%5Blevel%5D=H&qrcodeconfig%5Bqr_rotate%5D=0&qrcodeconfig%5Btext%5D=" + machineId + "&qrcodeconfig%5Bfontfamily%5D=msyh.ttf&qrcodeconfig%5Bfontsize%5D=30&qrcodeconfig%5Bfontcolor%5D=&qrcodeconfig%5Blogo_pos%5D=0&callback=__qrStyle1",
                headers);
        if (StringUtils.contains(s, "https:")) {
            String s1 = StringUtils.removeStart(s, "__qrStyle1('{\"qrcodeconfig\":\"");
            String s2 = StringUtils.removeEnd(s1, "\"}')");
            return StringUtils.replace(s2, "\\/", "/");
        }
        return null;
    }

    private static void download(String url, String machineId) throws IOException {
        HttpGet get = new HttpGet(url);
        get.addHeader("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.83 Safari/537.36");
        get.addHeader("Referer", "https://cli.im/url/info?e36f9f0994f2ac84578bed6213163ac2");
        HttpResponse response = httpClient.execute(get);
        byte[] bytes = EntityUtils.toByteArray(response.getEntity());
        FileUtils.writeByteArrayToFile(new File("/Users/huxiao/Downloads/qr/" + machineId + ".png"), bytes);
    }

    public static void main(String[] args) {
        String prefix = "A8C8EF";
        int start = 9100;
        for (int i = 0; i < 3000; i++) {
            String pad = StringUtils.leftPad(Objects.toString(start), 6, "0");
            String machineId = StringUtils.join(new String[] {prefix, pad});
            try {
                String url = getUrl(machineId);
                download(url, machineId);
                System.out.println("Finished download qr picture of " + machineId);
            } catch (IOException e) {
                e.printStackTrace();
            }
            start++;
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
            }
        }
    }
}
