package com.bxm.warcar.useragent.tiger;

import com.bxm.warcar.useragent.UserAgent;
import com.tiger.useragent.UserAgentInfo;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * @author allen
 * @date 2019/5/15
 * @since 1.0.0
 */
final class TigerUserAgent implements UserAgent {

    private final UserAgentInfo userAgentInfo;

    TigerUserAgent(UserAgentInfo userAgentInfo) {
        this.userAgentInfo = userAgentInfo;
    }

    @Override
    public CharSequence getOs() {
        return userAgentInfo.getOsName();
    }

    @Override
    public CharSequence getOsDetail() {
        return userAgentInfo.getOsDetail();
    }

    @Override
    public CharSequence getBrowser() {
        return userAgentInfo.getBrowserName();
    }

    @Override
    public CharSequence getBrowserDetail() {
        return userAgentInfo.getBrowserDetail();
    }

    @Override
    public CharSequence getDeviceType() {
        return userAgentInfo.getDeviceType();
    }

    @Override
    public CharSequence getDeviceBrand() {
        return userAgentInfo.getDeviceBrand();
    }

    @Override
    public CharSequence getDeviceName() {
        return userAgentInfo.getDeviceName();
    }

    @Override
    public Boolean isMobilePhone() {
        return userAgentInfo.getIsMobile();
    }

    @Override
    public CharSequence getNetType() {
        return userAgentInfo.getNetType();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
