/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.file;

import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.file.FileComparator;
import com.bxm.warcar.utils.file.FileMonitor;
import com.bxm.warcar.utils.file.SimpleDataTracker;
import com.bxm.warcar.utils.file.SimpleFingerprintTracker;
import com.bxm.warcar.utils.file.SystemFileComparator;
import com.bxm.warcar.utils.file.UpdateListener;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemFileMonitor
implements FileMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemFileMonitor.class);
    private final FileComparator fileComparator;
    private final ScheduledExecutorService scheduled = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("file-monitor"));
    private UpdateListener listener;

    public SystemFileMonitor(FileComparator fileComparator) {
        Preconditions.checkNotNull((Object)fileComparator);
        this.fileComparator = fileComparator;
    }

    @Override
    public void start() {
        try {
            this.fileComparator.compare();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.scheduled.scheduleWithFixedDelay(() -> {
            block3: {
                try {
                    boolean compare = this.fileComparator.compare();
                    if (!compare && null != this.listener) {
                        this.listener.updated();
                    }
                }
                catch (IOException e) {
                    if (!LOGGER.isErrorEnabled()) break block3;
                    LOGGER.error("compare: ", (Throwable)e);
                }
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void addListener(UpdateListener listener) {
        this.listener = listener;
    }

    public static void main(String[] args) {
        File data = new File(System.getProperty("java.io.tmpdir") + File.separator + "ipipnet.data");
        File fingerprint = new File(System.getProperty("java.io.tmpdir") + File.separator + "ipipnet.fingerprint");
        SystemFileComparator comparator = new SystemFileComparator(fingerprint, data, new SimpleFingerprintTracker("http://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/ipipnet.fingerprint", "ipipnet.fingerprint"), new SimpleDataTracker("http://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/ipipnet.datx", "ipipnet.datx"));
        SystemFileMonitor monitor = new SystemFileMonitor(comparator);
        monitor.addListener(() -> System.out.println("updated"));
        monitor.start();
    }
}

