package com.bxm.warcar.utils.response;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 *  接口返回结果model
 *  目前多在运营后台，活动中使用
 *
 * @ClassName ResultModel
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/8/7 18:01
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/8/7 18:01
 **/
public class ResultModel<T> implements Serializable {

    private static final long serialVersionUID = 9041530013023432967L;
    /**
     * 接口返回结果对象
     */
    private T returnValue;
    /**
     * 返回结果是否成功，true成功，false失败
     */
    private boolean isSuccessed = true;
    /**
     * 返回结果失败时的错误代码
     */
    private String errorCode;
    /**
     * 返回结果失败时的错误描述
     */
    private String errorDesc;

    public static <T> ResultModel<T> newInstance() {
        return new ResultModel<T>();
    }

    /**
     * 接口返回结果对象
     *
     * @return the returnValue
     */
    public T getReturnValue() {
        return returnValue;
    }

    /**
     * 接口返回结果对象
     *
     * @param returnValue the returnValue to set
     */
    public void setReturnValue(T returnValue) {
        this.returnValue = returnValue;
    }

    /**
     * 返回结果是否成功，true成功，false失败
     *
     * @return the isSuccessed
     */
    public boolean isSuccessed() {
        return isSuccessed;
    }

    /**
     * 返回结果是否成功，true成功，false失败
     *
     * @param isSuccessed the isSuccessed to set
     */
    public void setSuccessed(boolean isSuccessed) {
        this.isSuccessed = isSuccessed;
    }

    /**
     * 返回结果失败时的错误代码
     *
     * @return the errorCode
     */
    public String getErrorCode() {
        return errorCode;
    }

    /**
     * 返回结果失败时的错误代码
     *
     * @param errorCode the errorCode to set
     */
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * 返回结果失败时的错误描述
     *
     * @return the errorDesc
     */
    public String getErrorDesc() {
        return errorDesc;
    }

    /**
     * 返回结果失败时的错误描述
     *
     * @param errorDesc the errorDesc to set
     */
    public void setErrorDesc(String errorDesc) {
        this.errorDesc = errorDesc;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}
