/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.http.pool;

import com.bxm.warcar.utils.http.HttpPool;
import com.bxm.warcar.utils.http.RestTemplateUtils;
import com.bxm.warcar.utils.http.properties.HttpProperties;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplatePool
implements HttpPool {
    private final RestTemplate restTemplate;
    private final HttpProperties httpProperties;

    private ClientHttpRequestFactory httpRequestFactory() {
        return new HttpComponentsClientHttpRequestFactory(this.httpClient());
    }

    public RestTemplatePool(HttpProperties httpProperties) {
        this.httpProperties = httpProperties;
        this.restTemplate = this.restTemplate();
    }

    private RestTemplate restTemplate() {
        return new RestTemplate(this.httpRequestFactory());
    }

    private HttpClient httpClient() {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(this.httpProperties.getMaxTotal());
        connectionManager.setDefaultMaxPerRoute(this.httpProperties.getDefaultMaxPerRoute());
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.httpProperties.getSocketTimeout()).setConnectTimeout(this.httpProperties.getConnectTimeout()).setConnectionRequestTimeout(this.httpProperties.getConnectionRequestTimeout()).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    public RestTemplate builder() {
        return this.restTemplate;
    }

    @Override
    public String get(String url) {
        return (String)this.exchange(url, HttpMethod.GET).getBody();
    }

    @Override
    public String get(String url, Map<String, String> headers) {
        return this.get(url, Maps.newHashMap(), headers);
    }

    @Override
    public String get(String url, Map<String, Object> params, Map<String, String> headers) {
        return (String)this.exchange(url, headers, params, HttpMethod.GET, String.class).getBody();
    }

    @Override
    public String post(String url) {
        return (String)this.exchange(url, HttpMethod.POST).getBody();
    }

    @Override
    public String post(String url, Map<String, Object> params) {
        return this.post(url, params, Maps.newHashMap());
    }

    @Override
    public String post(String url, Map<String, Object> params, Map<String, String> headers) {
        return (String)this.exchange(url, headers, params, HttpMethod.POST, String.class).getBody();
    }

    @Override
    public String postRequestBody(String url, Object o, Map<String, String> headers) {
        return (String)this.exchange(url, headers, o, HttpMethod.POST, String.class).getBody();
    }

    public HttpEntity<String> exchange(String url, HttpMethod method) {
        return this.exchange(url, method, Maps.newHashMap());
    }

    public <T> HttpEntity<T> get(String url, Class<T> responseType) {
        return this.exchange(url, HttpMethod.GET, responseType);
    }

    public <T> HttpEntity<T> post(String url, Class<T> responseType) {
        return this.exchange(url, HttpMethod.POST, responseType);
    }

    public <T> HttpEntity<T> exchange(String url, HttpMethod method, Class<T> responseType) {
        return this.exchange(url, Maps.newHashMap(), method, responseType);
    }

    public <T> HttpEntity<T> exchange(String url, Map<String, String> headers, Object bodyParams, HttpMethod method, Class<T> responseType) {
        return this.exchange(url, headers, bodyParams, method, responseType, null);
    }

    public HttpEntity<String> exchange(String url, HttpMethod method, Map<String, Object> bodyParams) {
        return this.exchange(url, bodyParams, method, String.class);
    }

    public <T> HttpEntity<T> exchange(String url, Map<String, Object> bodyParams, HttpMethod method, Class<T> responseType) {
        return this.exchange(url, Maps.newHashMap(), bodyParams, method, responseType);
    }

    public <T> HttpEntity<T> exchange(String url, Map<String, String> headers, Object bodyParams, HttpMethod method, Class<T> responseType, String contentType) {
        if (MapUtils.isEmpty(headers)) {
            headers = Maps.newHashMap();
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        }
        HttpEntity httpEntity = new HttpEntity(bodyParams, RestTemplateUtils.headerParams(headers));
        if (bodyParams instanceof Map) {
            LinkedMultiValueMap<String, String> multiValueMap = RestTemplateUtils.praseBodyParams((Map)bodyParams);
            httpEntity = new HttpEntity(multiValueMap, RestTemplateUtils.headerParams(headers));
            return this.restTemplate.exchange(url, method, httpEntity, responseType, new Object[0]);
        }
        return this.restTemplate.exchange(url, method, httpEntity, responseType, new Object[0]);
    }
}

