/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.random;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomUtils;

public class RandomWeight<T> {
    private static final long DEF_COUNT = 0L;
    private List<Long> weights = new ArrayList<Long>();
    private List<T> items = new ArrayList<T>();
    List<Long> limits = new ArrayList<Long>();
    Map<Long, T> itemMap = new HashMap<Long, T>();
    long count = 0L;

    public void addItem(Integer weight, T item) {
        this.addItem((long)weight, item);
    }

    public void addItem(Long weight, T item) {
        assert (null != weight);
        assert (null != item);
        if (weight < 0L) {
            weight = 0L;
        }
        this.weights.add(weight);
        this.items.add(item);
        this.drawLimit(weight, item);
    }

    public boolean isEmpty() {
        return this.items.isEmpty() || this.weights.isEmpty();
    }

    public <T> T hit() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.items.size() == 1) {
            if (this.weights.get(0) > 0L) {
                return this.items.get(0);
            }
            return null;
        }
        T hitItem = null;
        long roll = RandomUtils.nextLong((long)0L, (long)this.count) + 1L;
        for (Long limit : this.limits) {
            if (roll > limit) continue;
            hitItem = this.itemMap.get(limit);
            break;
        }
        return hitItem;
    }

    private void resetLimit() {
        this.limits.clear();
        this.itemMap.clear();
        this.count = 0L;
        for (int i = 0; i < this.weights.size(); ++i) {
            Long weight = this.weights.get(i);
            T item = this.items.get(i);
            this.drawLimit(weight, item);
        }
    }

    private void drawLimit(Long weight, T item) {
        this.count += weight.longValue();
        this.limits.add(this.count);
        this.itemMap.put(this.count, item);
    }
}

