package com.bxm.warcar.utils.crypto;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

/**
 * cipher for AES
 *
 * @author allen
 * @date 2021-08-26
 * @since 1.0
 */
public final class AesCipher {

    private static final String KEY_ALGORITHM  = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    private static final Cipher CIPHER;

    static {
        try {
            CIPHER = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        } catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encrypt(byte[] key, byte[] content) throws Exception {
        if (Objects.isNull(key) || Objects.isNull(content)) {
            return null;
        }
        SecretKeySpec sKey = getSecretKeySpec(key);
        CIPHER.init(Cipher.ENCRYPT_MODE, sKey);
        return CIPHER.doFinal(content);
    }

    public static byte[] decrypt(byte[] key, byte[] content) throws Exception {
        if (content == null) {
            return null;
        }
        SecretKeySpec sKey = getSecretKeySpec(key);
        CIPHER.init(Cipher.DECRYPT_MODE, sKey);
        return CIPHER.doFinal(content);
    }

    private static SecretKeySpec getSecretKeySpec(byte[] key) {
        return new SecretKeySpec(key, KEY_ALGORITHM);
    }
}
