package com.bxm.warcar.utils.response;

/**
 *  接口返回结果model 工厂类
 *  目前多在运营后台，活动中使用
 *
 * @ClassName ResultModelFactory
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/8/7 18:01
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/8/7 18:01
 **/
@Deprecated
public final class ResultModelFactory {

    private ResultModelFactory(){}

    /**
     * 返回  ResultModel 对象
     *
     * @param
     * @return com.bxm.warcar.utils.response.ResultModel<T>
     * @throws
     * @author kk.xie
     * @date 2018/8/8 10:10
     */
    public static <T> ResultModel<T> getResultModel(){
        return ResultModel.newInstance();
    }

    /**
     * 成功--无返回数据
     *
     * @param
     * @return com.bxm.warcar.utils.response.ResultModel<T>
     * @throws
     * @author kk.xie
     * @date 2018/8/8 10:10
     */
    public static  <T> ResultModel<T> SUCCESS(){
        return  SUCCESS(null);
    }

    /**
     * 成功--有返回数据
     *
     * @param returnValue
     * @return com.bxm.warcar.utils.response.ResultModel<T>
     * @throws
     * @author kk.xie
     * @date 2018/8/8 10:11
     */
    public static <T> ResultModel<T> SUCCESS(T returnValue) {
        return getResultModel(returnValue,true, null, null);
    }

    /**
     * 失败，无参数
     *
     * @param
     * @return com.bxm.warcar.utils.response.ResultModel<T>
     * @throws
     * @author kk.xie
     * @date 2018/7/31 15:09
     */
    public static <T> ResultModel<T> FAILED(){
        return FAILED(ResultErrorCode.ERROR.errorCode, ResultErrorCode.ERROR.errorDesc);
    }

    /**
     * 400 -- 参数错误
     *
     * @param
     * @return com.bxm.warcar.utils.response.ResultModel<T>
     * @throws
     * @author kk.xie
     * @date 2018/8/8 10:15
     */
    public static <T> ResultModel<T> FAILED400() {
        return FAILED(ResultErrorCode.REQUEST_ERROR.errorCode, ResultErrorCode.REQUEST_ERROR.errorDesc);
    }

    /**
     * 400 -- 参数错误
     *
     * @param errorDesc
     * @return com.bxm.warcar.utils.response.ResultModel<T>
     * @throws
     * @author kk.xie
     * @date 2018/8/8 10:17
     */
    public static <T> ResultModel<T> FAILED400(String errorDesc) {
        return FAILED(ResultErrorCode.REQUEST_ERROR.errorCode, errorDesc);
    }

    /**
     * 401 -- 登陆失败
     *
     * @param
     * @return com.bxm.warcar.utils.response.ResultModel<T>
     * @throws
     * @author kk.xie
     * @date 2018/8/8 10:17
     */
    public static <T> ResultModel<T> FAILED401(){
        return FAILED(ResultErrorCode.LOGIN_ERROR.errorCode, ResultErrorCode.LOGIN_ERROR.errorDesc);
    }

    /**
     * 401 -- 登陆失败
     *
     * @param errorDesc
     * @return com.bxm.warcar.utils.response.ResultModel<T>
     * @throws
     * @author kk.xie
     * @date 2018/8/8 10:17
     */
    public static <T> ResultModel<T> FAILED401(String errorDesc){
        return FAILED(ResultErrorCode.LOGIN_ERROR.errorCode, errorDesc);
    }

    /**
     * 408 -- 请求超时
     *
     * @param
     * @return com.bxm.warcar.utils.response.ResultModel<T>
     * @throws
     * @author kk.xie
     * @date 2018/8/8 10:18
     */
    public static <T> ResultModel<T> FAILED408(){
        return FAILED(ResultErrorCode.TIMEOUT_ERROR.errorCode, ResultErrorCode.TIMEOUT_ERROR.errorDesc);
    }

    /**
     * 408 -- 请求超时
     *
     * @param errorDesc
     * @return com.bxm.warcar.utils.response.ResultModel<T>
     * @throws
     * @author kk.xie
     * @date 2018/8/8 10:18
     */
    public static <T> ResultModel<T> FAILED408(String errorDesc){
        return FAILED(ResultErrorCode.TIMEOUT_ERROR.errorCode, errorDesc);
    }

    /**
     * 500 -- 系统错误
     *
     * @param
     * @return com.bxm.warcar.utils.response.ResultModel<T>
     * @throws
     * @author kk.xie
     * @date 2018/8/8 10:19
     */
    public static <T> ResultModel<T> FAILED500() {
        return FAILED(ResultErrorCode.SYSTEM_ERROR.errorCode, ResultErrorCode.SYSTEM_ERROR.errorDesc);
    }

    /**
     * 500 -- 系统错误
     *
     * @param errorDesc
     * @return com.bxm.warcar.utils.response.ResultModel<T>
     * @throws
     * @author kk.xie
     * @date 2018/8/8 10:20
     */
    public static <T> ResultModel<T> FAILED500(String errorDesc) {
        return FAILED(ResultErrorCode.SYSTEM_ERROR.errorCode, errorDesc);
    }

    /**
     * 返回失败，失败编码自定义
     * @param errorCode 失败编码
     * @param errorDesc 失败描述
     * @param <T>
     * @return
     */
    public static <T> ResultModel<T> FAILED(String errorCode, String errorDesc) {
        return getResultModel(null,false, errorCode, errorDesc);
    }

    /**
     * 创建返回结果
     * @param returnValue
     * @param success
     * @param errorCode
     * @param errorDesc
     * @param <T>
     * @return
     */
    public static <T> ResultModel<T> getResultModel(T returnValue,boolean success,String errorCode,String errorDesc){
        ResultModel resultModel = getResultModel();
        resultModel.setErrorCode(errorCode);
        resultModel.setErrorDesc(errorDesc);
        resultModel.setSuccessed(success);
        if(null != returnValue){
            resultModel.setReturnValue(returnValue);
        }
        return resultModel;
    }


    public enum ResultErrorCode {
        /**
         * 成功
         */
        SUCCESS("1","成功"),
        /**
         * 失败
         */
        ERROR("0", "失败"),
        /**
         * 请求出错
         */
        REQUEST_ERROR("400", "the parameters error"),
        /**
         * 登录出错
         */
        LOGIN_ERROR("401", "login error"),
        /**
         * 超时
         */
        TIMEOUT_ERROR("408", "login error"),
        /**
         * 系统错误
         */
        SYSTEM_ERROR("500", "system error");

        String errorCode;
        String errorDesc;

        ResultErrorCode(String errorCode,String errorDesc){
            this.errorCode = errorCode;
            this.errorDesc = errorDesc;
        }
    }
}
