/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public abstract class LifeCycle {
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    protected abstract void doInit();

    protected abstract void doDestroy();

    public void init() {
        if (!this.lock.tryLock()) {
            throw new RuntimeException("LifeCycle is processing for lifecycle.");
        }
        if (this.isInitialized()) {
            throw new RuntimeException("LifeCycle has been initialized.");
        }
        try {
            this.doInit();
        }
        finally {
            this.initialized.set(true);
            this.lock.unlock();
        }
    }

    protected boolean isInitialized() {
        return this.initialized.get();
    }

    public void destroy() {
        if (!this.lock.tryLock()) {
            throw new RuntimeException("LifeCycle is processing for lifecycle");
        }
        if (!this.isInitialized()) {
            throw new RuntimeException("LifeCycle has been destroyed.");
        }
        try {
            this.doDestroy();
        }
        finally {
            this.initialized.set(false);
            this.lock.unlock();
        }
    }
}

