/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.crypto;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;

public class BouncyCastleAesCipher {
    public static byte[] encrypt(byte[] key, byte[] content) throws Exception {
        PaddedBufferedBlockCipher aes = new PaddedBufferedBlockCipher((BlockCipher)new AESEngine());
        KeyParameter parameters = new KeyParameter(key);
        aes.init(true, (CipherParameters)parameters);
        return BouncyCastleAesCipher.cipherData(aes, content);
    }

    public static byte[] decrypt(byte[] key, byte[] content) throws Exception {
        PaddedBufferedBlockCipher aes = new PaddedBufferedBlockCipher((BlockCipher)new AESEngine());
        KeyParameter parameters = new KeyParameter(key);
        aes.init(false, (CipherParameters)parameters);
        return BouncyCastleAesCipher.cipherData(aes, content);
    }

    private static byte[] cipherData(PaddedBufferedBlockCipher cipher, byte[] data) throws Exception {
        int minSize = cipher.getOutputSize(data.length);
        byte[] outBuf = new byte[minSize];
        int length1 = cipher.processBytes(data, 0, data.length, outBuf, 0);
        int length2 = cipher.doFinal(outBuf, length1);
        int actualLength = length1 + length2;
        byte[] result = new byte[actualLength];
        System.arraycopy(outBuf, 0, result, 0, result.length);
        return result;
    }
}

