/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.crypto;

import com.bxm.warcar.utils.crypto.BouncyCastleAesCipher;
import java.util.function.Function;

public class StringAesCipher {
    private final Function<String, byte[]> keySerializer;
    private final Function<String, byte[]> contentEncryptSerializer;
    private final Function<byte[], String> contentEncryptDeserializer;
    private final Function<String, byte[]> contentDecryptSerializer;
    private final Function<byte[], String> contentDecryptDeserializer;

    public String encrypt(String key, String content) throws Exception {
        byte[] k = this.keySerializer.apply(key);
        byte[] v = this.contentEncryptSerializer.apply(content);
        byte[] b = BouncyCastleAesCipher.encrypt(k, v);
        return this.contentEncryptDeserializer.apply(b);
    }

    public String decrypt(String key, String content) throws Exception {
        byte[] k = this.keySerializer.apply(key);
        byte[] v = this.contentDecryptSerializer.apply(content);
        byte[] b = BouncyCastleAesCipher.decrypt(k, v);
        return this.contentDecryptDeserializer.apply(b);
    }

    public static StringAesCipherBuilder builder() {
        return new StringAesCipherBuilder();
    }

    public StringAesCipher(Function<String, byte[]> keySerializer, Function<String, byte[]> contentEncryptSerializer, Function<byte[], String> contentEncryptDeserializer, Function<String, byte[]> contentDecryptSerializer, Function<byte[], String> contentDecryptDeserializer) {
        this.keySerializer = keySerializer;
        this.contentEncryptSerializer = contentEncryptSerializer;
        this.contentEncryptDeserializer = contentEncryptDeserializer;
        this.contentDecryptSerializer = contentDecryptSerializer;
        this.contentDecryptDeserializer = contentDecryptDeserializer;
    }

    public static class StringAesCipherBuilder {
        private Function<String, byte[]> keySerializer;
        private Function<String, byte[]> contentEncryptSerializer;
        private Function<byte[], String> contentEncryptDeserializer;
        private Function<String, byte[]> contentDecryptSerializer;
        private Function<byte[], String> contentDecryptDeserializer;

        StringAesCipherBuilder() {
        }

        public StringAesCipherBuilder keySerializer(Function<String, byte[]> keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        public StringAesCipherBuilder contentEncryptSerializer(Function<String, byte[]> contentEncryptSerializer) {
            this.contentEncryptSerializer = contentEncryptSerializer;
            return this;
        }

        public StringAesCipherBuilder contentEncryptDeserializer(Function<byte[], String> contentEncryptDeserializer) {
            this.contentEncryptDeserializer = contentEncryptDeserializer;
            return this;
        }

        public StringAesCipherBuilder contentDecryptSerializer(Function<String, byte[]> contentDecryptSerializer) {
            this.contentDecryptSerializer = contentDecryptSerializer;
            return this;
        }

        public StringAesCipherBuilder contentDecryptDeserializer(Function<byte[], String> contentDecryptDeserializer) {
            this.contentDecryptDeserializer = contentDecryptDeserializer;
            return this;
        }

        public StringAesCipher build() {
            return new StringAesCipher(this.keySerializer, this.contentEncryptSerializer, this.contentEncryptDeserializer, this.contentDecryptSerializer, this.contentDecryptDeserializer);
        }

        public String toString() {
            return "StringAesCipher.StringAesCipherBuilder(keySerializer=" + this.keySerializer + ", contentEncryptSerializer=" + this.contentEncryptSerializer + ", contentEncryptDeserializer=" + this.contentEncryptDeserializer + ", contentDecryptSerializer=" + this.contentDecryptSerializer + ", contentDecryptDeserializer=" + this.contentDecryptDeserializer + ")";
        }
    }
}

