/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.warcar.validate;

import org.apache.commons.beanutils.PropertyUtils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractValidator implements Validator {

	private final Field field;
	private final String fieldName;
	/**
	 * 新增默认值
	 */
	private String defaultValue;

	public AbstractValidator(Field field) {
		super();
		if (null == field) {
			throw new NullPointerException("field");
		}
		this.field = field;
		this.fieldName = field.getName();
	}

	public AbstractValidator(Field field, String defaultValue) {
		super();
		if (null == field) {
			throw new NullPointerException("field");
		}
		this.field = field;
		this.fieldName = field.getName();
		this.defaultValue = defaultValue;
	}

	protected String getFieldDesc(Field f) {
		return new StringBuilder(64).append(f.getDeclaringClass().getName()).append(".").append(
				getField().getName()).toString();
	}

	protected String getFieldDesc() {
		return getFieldDesc(getField());
	}

	@Override
	public void validate(Object input) throws ValidateException, ConstraintViolationException {
		if (null == input)
			throw new NullPointerException("input");
		try {
			doValidate(input);
		} catch (Exception e) {
			if (e instanceof ValidateException)
				throw (ValidateException) e;
			throw new ValidateException(e);
		}
	}

	protected abstract void doValidate(Object input) throws Exception;

	protected Object getValue(Object input) throws IllegalArgumentException, IllegalAccessException {
		try {
			return PropertyUtils.getProperty(input, fieldName);
		} catch (InvocationTargetException e) {
			throw new ValidateException("getValue:", e);
		} catch (NoSuchMethodException e) {
			throw new ValidateException("getValue:", e);
		}
	}

	protected void setValue(Object input, String value) throws IllegalArgumentException, IllegalAccessException {
		try {
			// 支持基本数据类型的默认值赋值
			Class<?> aClass = Class.forName(getField().getGenericType().getTypeName());
			if(aClass.equals(String.class)){
				PropertyUtils.setProperty(input, fieldName, value);
			}else{
				Method m = aClass.getMethod("valueOf", String.class);
				Object obj = m.invoke(aClass, value);
				PropertyUtils.setProperty(input, fieldName, obj);
			}
		} catch (InvocationTargetException e) {
			throw new ValidateException("setValue:", e);
		} catch (NoSuchMethodException e) {
			throw new ValidateException("setValue:", e);
		} catch (ClassNotFoundException e) {
			throw new ValidateException("setValue:", e);
		}
	}

	protected Field getField() {
		return field;
	}

	public String getFieldName() {
		return fieldName;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	@Override
	public String toString() {
		return this.getConstraintDesc();
	}
}
