/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.validate.internal;

import com.bxm.warcar.validate.AbstractValidator;
import com.bxm.warcar.validate.Validator;

import java.lang.reflect.Field;


public class CustomValidator extends AbstractValidator {

	private final Validator custom;

	public CustomValidator(Field field, Validator custom) {
		super(field);
		if (null == custom)
			throw new NullPointerException("CustomValidator");
		this.custom = custom;
	}

	@Override
	protected void doValidate(Object input) throws Exception {
		Object v = getValue(input);
		custom.validate(v);
	}

	@Override
	public String getConstraintDesc() {
		return custom.getConstraintDesc();
	}
}
