/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.validate.internal;

import com.bxm.warcar.validate.ConstraintViolationException;
import com.bxm.warcar.validate.ValidateException;
import com.bxm.warcar.validate.Validator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class BeanValidator
implements Validator {
    private final List<Validator> elementValidator = new CopyOnWriteArrayList<Validator>();

    @Override
    public void validate(Object input) throws ValidateException, ConstraintViolationException {
        if (null == input) {
            throw new NullPointerException("input");
        }
        for (Validator ev : this.elementValidator) {
            ev.validate(input);
        }
    }

    @Override
    public String getConstraintDesc() {
        return "Bean Validator";
    }

    public String toString() {
        return "Bean Validator";
    }

    public void register(List<Validator> validators) {
        if (null == validators) {
            throw new NullPointerException("validators");
        }
        for (Validator v : validators) {
            this.register(v);
        }
    }

    public void register(Validator validator) {
        if (null == validator) {
            throw new NullPointerException("validator");
        }
        this.elementValidator.add(validator);
    }

    public void clear() {
        this.elementValidator.clear();
    }
}

