package com.bxm.warcar.web.exceptions;

import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author allen
 * @since 1.0.0
 */
@ControllerAdvice(annotations = RestController.class)
public class GlobalControllerExceptionHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalControllerExceptionHandler.class);

    @ExceptionHandler
    @ResponseBody
    public ResponseModel exceptionHandler(Exception e) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("exceptionHandler: ", e);
        }
        ResponseModel<Object> failed500 = ResponseModelFactory.FAILED500();
        failed500.setMessage(e.getMessage());
        return failed500;
    }
}
