package com.bxm.warcar.web.util;

import java.io.Serializable;

/**
 * <p>加密处理消息对象，泛型需要与 {@link Encrypted#model()} 保持一致，否则不能序列化。</p>
 *
 * 请求时只需要填充 {@link #message} 和 {@link #cipher} 属性，框架会对消息对象解密处理后，将解密的结果赋值给 {@link #object} 属性。
 * <li>{@code message} 泛型对象{@code JSON}序列化之后的加密数据</li>
 * <li>{@code cipher} 加解密处理版本，需要扩展请实现 {@link Encryptor} 接口</li>
 *
 * <pre>
 * 示例：
 *
 * &#64;Encrypted(model = CipherRequest.class, encryptResponseEntity = true)
 * &#64;PostMapping("/cipher")
 * public ResponseEntity&lt;CipherResponse&gt; cipher(@RequestBody EncryptedMessage&lt;CipherRequest&gt; message) {
 *     CipherRequest request = message.getObject();
 *     CipherResponse response = new CipherResponse();
 *     return ResponseEntity.ok(response);
 * }
 *
 * 请求：
 * {
 *     "message" : "nQzAdYgTAAa4sFZ9+3gcPlSLSxe1QHnD1RpNHGXOIGw=",
 *     "cipher" : 2
 * }
 *
 * 响应：
 * S87BY4YXyuVTmJa9riMOBQ==
 *
 * </pre>
 * @author allen
 * @date 2020-10-09
 * @since 1.0
 */
public class EncryptedMessage<T> implements Serializable {

    private static final long serialVersionUID = 4108008706152966826L;

    private String message;
    private Integer cipher;

    private T object;

    String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    Integer getCipher() {
        return cipher;
    }

    public void setCipher(Integer cipher) {
        this.cipher = cipher;
    }

    public T getObject() {
        return object;
    }

    public void setObject(T object) {
        this.object = object;
    }
}
