package com.bxm.warcar.web.util;

import com.bxm.warcar.web.util.serialization.ByteArraySerialization;
import com.bxm.warcar.web.util.serialization.JsonSerialization;
import com.bxm.warcar.web.util.serialization.PrimitiveSerialization;

/**
 * 序列化接口
 *
 * @see JsonSerialization
 * @see ByteArraySerialization
 * @see PrimitiveSerialization
 * @author allen
 * @date 2020-10-12
 * @since 1.0
 */
public interface Serialization {

    /**
     * 将对象序列化成字符串
     *
     * @param responseBody 返回的对象实例
     * @return 字符串
     */
    String serialize(Object responseBody);
}
