package com.bxm.warcar.web.util.serialization;

import com.bxm.warcar.web.util.Serialization;

import java.nio.charset.StandardCharsets;
import java.util.Objects;

/**
 * {@code byte[]} 序列化实现，它只是适合可以直接转化成可读 {@link String} 的字节码。否则建议自行扩展可转化为 {@code Hex} 或 {@code Base64} 字符的实现类。
 * @author allen
 * @date 2020-10-12
 * @since 1.0
 */
public class ByteArraySerialization implements Serialization {

    @Override
    public String serialize(Object responseBody) {
        if (responseBody instanceof byte[]) {
            return new String((byte[]) responseBody, StandardCharsets.UTF_8);
        }
        return Objects.toString(responseBody);
    }
}
