package com.bxm.warcar.zk.listener.node;

import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.listener.Changed;
import com.bxm.warcar.zk.listener.NodeChangedListener;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/**
 * @author allen
 * @since 1.0.0
 */
public class NodeChanged extends LifeCycle implements Changed {

    private static final Logger LOGGER = LoggerFactory.getLogger(NodeChanged.class);

    private final ZkClientHolder zkClientHolder;
    private final String path;
    private final NodeChangedListener listener;

    private NodeCache cache;

    public NodeChanged(ZkClientHolder zkClientHolder, String path, NodeChangedListener listener) {
        this.zkClientHolder = zkClientHolder;
        this.path = path;
        this.listener = listener;
    }

    @Override
    public void addListener(NodeChangedListener listener) {
        if (null != listener) {
            cache.getListenable().addListener(new NodeCacheListener() {
                @Override
                public void nodeChanged() throws Exception {
                    listener.update(path, cache.getCurrentData().getData());
                }
            });
        }
    }

    @Override
    protected void doInit() {
        cache = new NodeCache(zkClientHolder.get(), path);
        try {
            cache.start();
        } catch (Exception e) {
            throw new RuntimeException("start: ", e);
        }
        this.addListener(listener);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Zookeeper path: {} was listening the node!", path);
        }
    }

    @Override
    protected void doDestroy() {
        if (null != cache) {
            try {
                cache.close();
            } catch (IOException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("close: ", e);
                }
            }
        }
    }
}
