/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.zk.listener.node;

import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.listener.Changed;
import com.bxm.warcar.zk.listener.NodeChangedListener;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeChanged
extends LifeCycle
implements Changed {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeChanged.class);
    private final ZkClientHolder zkClientHolder;
    private final String path;
    private final NodeChangedListener listener;
    private NodeCache cache;

    public NodeChanged(ZkClientHolder zkClientHolder, String path, NodeChangedListener listener) {
        this.zkClientHolder = zkClientHolder;
        this.path = path;
        this.listener = listener;
    }

    @Override
    public void addListener(NodeChangedListener listener) {
        if (null != listener) {
            this.cache.getListenable().addListener(() -> listener.update(this.path, this.cache.getCurrentData().getData()), (Executor)listener.getExecutorService());
        }
    }

    protected void doInit() {
        this.cache = new NodeCache(this.zkClientHolder.get(), this.path);
        try {
            this.cache.start();
        }
        catch (Exception e) {
            throw new RuntimeException("start: ", e);
        }
        this.addListener(this.listener);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Zookeeper path: {} was listening the node!", (Object)this.path);
        }
    }

    protected void doDestroy() {
        block3: {
            if (null != this.cache) {
                try {
                    this.cache.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isErrorEnabled()) break block3;
                    LOGGER.error("close: ", (Throwable)e);
                }
            }
        }
    }
}

