/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.impls.jvm;

import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import java.util.concurrent.ConcurrentHashMap;

public class JvmFetcher
implements Fetcher {
    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls) {
        return this.fetch(keyGenerator, dataExtractor, cls, 0);
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        if (null == keyGenerator) {
            throw new NullPointerException("keyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (null == key || "".equals(key.trim())) {
            throw new NullPointerException("key");
        }
        Object fromCache = this.cache.get(key);
        if (null != fromCache) {
            return (T)fromCache;
        }
        T fromStore = null;
        if (null != dataExtractor) {
            fromStore = dataExtractor.extract();
        }
        if (null != fromStore) {
            this.cache.put(key, fromStore);
            return fromStore;
        }
        return null;
    }
}

