/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.impls.redis;

import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.serialization.JSONSerialization;
import org.apache.commons.lang.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisFetcher
implements Fetcher {
    private final JedisPool jedisPool;
    private final JSONSerialization serialization;

    public JedisFetcher(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
        this.serialization = new JSONSerialization();
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls) {
        return this.fetch(keyGenerator, dataExtractor, cls, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T fetch(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        if (null == keyGenerator) {
            throw new NullPointerException("keyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            String value = jedis.get(key);
            if (null != value) {
                T t = this.serialization.deserialize(value, cls);
                return t;
            }
            T fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                jedis.set(key, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            T t = fromStore;
            return t;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

