/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.impls.redis;

import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.serialization.JSONSerialization;
import org.apache.commons.lang.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisUpdater
implements Updater {
    private final JedisPool jedisPool;
    private final JSONSerialization serialization;

    public JedisUpdater(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
        this.serialization = new JSONSerialization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String key, Object value, int expireTimeInSecond) {
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        if (null == value) {
            throw new NullPointerException("value");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.set(key, this.serialization.serialize(value));
            if (expireTimeInSecond > 0) {
                jedis.expire(key, expireTimeInSecond);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void update(String key, Object value) {
        this.update(key, value, 0);
    }

    @Override
    public void remove(String key) {
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.del(key);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

