/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.push;

import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Converter;
import com.bxm.warcar.cache.push.Pushable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractPushable
implements Pushable {
    protected final Converter converter;

    public AbstractPushable() {
        this(Converter.DEFAULT);
    }

    public AbstractPushable(Converter converter) {
        this.converter = converter;
    }

    protected abstract Object serialize(byte[] var1);

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        Updater updater = this.getUpdater();
        if (null == updater) {
            throw new NullPointerException("updater");
        }
        String cacheKey = this.getCacheKey(parameters);
        if (StringUtils.isBlank((String)cacheKey)) {
            throw new NullPointerException("cacheKey");
        }
        Object object = this.serialize(data);
        updater.update(cacheKey, this.converter.convert(object));
    }
}

