/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.alions;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.MessageListener;
import com.bxm.warcar.utils.LifeCycle;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class AlionsConsumer
extends LifeCycle
implements Consumer {
    private final Properties properties = new Properties();
    private com.aliyun.openservices.ons.api.Consumer consumer;
    private final MessageListener messageListener;
    private String subExpression;

    public AlionsConsumer(String consumerId, String accessKey, String secretKey, MessageListener messageListener) {
        Preconditions.checkNotNull((Object)messageListener);
        this.properties.put("ConsumerId", consumerId);
        this.properties.put("AccessKey", accessKey);
        this.properties.put("SecretKey", secretKey);
        this.consumer = ONSFactory.createConsumer((Properties)this.properties);
        if (StringUtils.isBlank((String)this.subExpression)) {
            this.subExpression = "*";
        }
        this.messageListener = messageListener;
    }

    @Override
    protected void doInit() {
        if (null != this.consumer) {
            String topic = this.messageListener.getTopic();
            if (StringUtils.isBlank((String)topic)) {
                throw new RuntimeException("topic must has not blank!");
            }
            this.consumer.subscribe(topic, this.subExpression, new com.aliyun.openservices.ons.api.MessageListener(){

                public Action consume(com.aliyun.openservices.ons.api.Message message, ConsumeContext context) {
                    Message msg = new Message();
                    msg.setTopic(message.getTopic());
                    msg.setBody(message.getBody());
                    msg.setTags(message.getTag());
                    msg.setMsgId(message.getMsgID());
                    ConsumeStatus status = AlionsConsumer.this.messageListener.consume(Lists.newArrayList((Object[])new Message[]{msg}), context);
                    switch (status) {
                        case CONSUME_SUCCESS: {
                            return Action.CommitMessage;
                        }
                    }
                    return Action.ReconsumeLater;
                }
            });
            if (this.consumer.isClosed()) {
                this.consumer.start();
            }
        }
    }

    @Override
    protected void doDestroy() {
        this.shutdown();
    }

    @Override
    public void suspend() {
        if (this.consumer.isStarted()) {
            this.consumer.shutdown();
        }
    }

    @Override
    public void shutdown() {
        if (this.consumer.isStarted()) {
            this.consumer.shutdown();
        }
    }

    public void setSubExpression(String subExpression) {
        this.subExpression = subExpression;
    }
}

