/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.impls.redis;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.serialization.JSONSerialization;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisUpdater
implements Updater {
    private final JedisPool jedisPool;
    private final JSONSerialization serialization;
    private boolean enableAllField = true;
    private String allFieldName = "____ALL____";

    public JedisUpdater(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
        this.serialization = new JSONSerialization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(KeyGenerator keyGenerator, Object value, int expireTimeInSecond) {
        Preconditions.checkNotNull((Object)keyGenerator);
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        if (null == value) {
            throw new NullPointerException("value");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.set(key, this.serialization.serialize(value));
            if (expireTimeInSecond > 0) {
                jedis.expire(key, expireTimeInSecond);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void update(KeyGenerator keyGenerator, Object value) {
        this.update(keyGenerator, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(KeyGenerator keyGenerator) {
        Preconditions.checkNotNull((Object)keyGenerator);
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.del(key);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void hupdate(KeyGenerator keyGenerator, String field, Object value) {
        this.hupdate(keyGenerator, field, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hupdate(KeyGenerator keyGenerator, String field, Object value, int expireTimeInSecond) {
        Preconditions.checkNotNull((Object)keyGenerator);
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        if (null == value) {
            throw new NullPointerException("value");
        }
        if (StringUtils.isBlank((String)field)) {
            throw new NullPointerException("field");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.hset(key, field, this.serialization.serialize(value));
            if (expireTimeInSecond > 0) {
                jedis.expire(key, expireTimeInSecond);
            }
            if (this.enableAllField) {
                jedis.hdel(key, new String[]{this.allFieldName});
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public boolean isEnableAllField() {
        return this.enableAllField;
    }

    public void setEnableAllField(boolean enableAllField) {
        this.enableAllField = enableAllField;
    }

    public String getAllFieldName() {
        return this.allFieldName;
    }

    public void setAllFieldName(String allFieldName) {
        this.allFieldName = allFieldName;
    }
}

