/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.container.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @author allen
 * @since 1.0.0
 */
@ManagedResource
public class RemoteExecutor {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteExecutor.class);

    private final List<Shutdown> beans = Lists.newArrayList();
    private final TaskMetrics taskMetrics;

    public RemoteExecutor(TaskMetrics taskMetrics) {
        Preconditions.checkNotNull(taskMetrics);
        this.taskMetrics = taskMetrics;
    }

    public void addAll(List<Shutdown> beans) {
        this.beans.addAll(beans);
    }

    public void add(Shutdown bean) {
        this.beans.add(bean);
    }

    @ManagedOperation
    public void shutdown() {
        for (Shutdown bean : beans) {
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Starting invocation before shutdown method of bean: {}", bean);
                }
                bean.before();
            } catch (IllegalStateException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("before: ", e);
                }
            }
        }

        AtomicLong tasks = taskMetrics.getTasks();

        while (tasks.get() > 0) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException ignore) {
            }

            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Wait for {} tasks execute complete", tasks.get());
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("System will shuting down...");
        }
        System.exit(0);
    }
}
