/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.impls.redis;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.serialization.JSONSerialization;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisUpdater
implements Updater {
    private final JedisPool jedisPool;
    private final JSONSerialization serialization;

    public JedisUpdater(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
        this.serialization = new JSONSerialization();
    }

    @Override
    public Object getClientOriginal() {
        return this.jedisPool;
    }

    @Override
    public void update(KeyGenerator keyGenerator, Object value, int expireTimeInSecond) {
        this.updateWithSelector(keyGenerator, value, expireTimeInSecond, -1);
    }

    @Override
    public void update(KeyGenerator keyGenerator, Object value) {
        this.update(keyGenerator, value, 0);
    }

    @Override
    public void updateWithSelector(KeyGenerator keyGenerator, Object value, int selector) {
        this.updateWithSelector(keyGenerator, value, 0, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWithSelector(KeyGenerator keyGenerator, Object value, int expireTimeInSecond, int selector) {
        Preconditions.checkNotNull((Object)keyGenerator);
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        if (null == value) {
            throw new NullPointerException("value");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            jedis.set(key, this.serialization.serialize(value));
            if (expireTimeInSecond > 0) {
                jedis.expire(key, expireTimeInSecond);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void remove(KeyGenerator keyGenerator) {
        this.removeWithSelector(keyGenerator, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWithSelector(KeyGenerator keyGenerator, int selector) {
        Preconditions.checkNotNull((Object)keyGenerator);
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            jedis.del(key);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void hupdate(KeyGenerator keyGenerator, String field, Object value) {
        this.hupdate(keyGenerator, field, value, 0);
    }

    @Override
    public void hupdate(KeyGenerator keyGenerator, String field, Object value, int expireTimeInSecond) {
        this.hupdateWithSelector(keyGenerator, field, value, expireTimeInSecond, -1);
    }

    @Override
    public void hupdateWithSelector(KeyGenerator keyGenerator, String field, Object value, int selector) {
        this.hupdateWithSelector(keyGenerator, field, value, 0, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hupdateWithSelector(KeyGenerator keyGenerator, String field, Object value, int expireTimeInSecond, int selector) {
        Preconditions.checkNotNull((Object)keyGenerator);
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        if (null == value) {
            throw new NullPointerException("value");
        }
        if (StringUtils.isBlank((String)field)) {
            throw new NullPointerException("field");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            jedis.hset(key, field, this.serialization.serialize(value));
            if (expireTimeInSecond > 0) {
                jedis.expire(key, expireTimeInSecond);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void hremove(KeyGenerator keyGenerator, String ... field) {
        this.hremoveWithSelector(keyGenerator, -1, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hremoveWithSelector(KeyGenerator keyGenerator, int selector, String ... field) {
        Preconditions.checkNotNull((Object)keyGenerator);
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            jedis.hdel(key, field);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void hmupdate(KeyGenerator keyGenerator, Map<String, String> hash) {
        this.hmupdate(keyGenerator, hash, 0);
    }

    @Override
    public void hmupdate(KeyGenerator keyGenerator, Map<String, String> hash, int expireTimeInSecond) {
        this.hmupdateWithSelector(keyGenerator, hash, expireTimeInSecond, -1);
    }

    @Override
    public void hmupdateWithSelector(KeyGenerator keyGenerator, Map<String, String> hash, int selector) {
        this.hmupdateWithSelector(keyGenerator, hash, 0, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hmupdateWithSelector(KeyGenerator keyGenerator, Map<String, String> hash, int expireTimeInSecond, int selector) {
        Preconditions.checkNotNull((Object)keyGenerator);
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            jedis.hmset(key, hash);
            if (expireTimeInSecond > 0) {
                jedis.expire(key, expireTimeInSecond);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

