/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.container.task;

import com.bxm.warcar.container.task.Shutdown;
import com.bxm.warcar.container.task.TaskMetrics;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class RemoteExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteExecutor.class);
    private final List<Shutdown> beans = Lists.newArrayList();
    private final TaskMetrics taskMetrics;

    public RemoteExecutor(TaskMetrics taskMetrics) {
        Preconditions.checkNotNull((Object)taskMetrics);
        this.taskMetrics = taskMetrics;
    }

    public void addAll(List<Shutdown> beans) {
        this.beans.addAll(beans);
    }

    public void add(Shutdown bean) {
        this.beans.add(bean);
    }

    @ManagedOperation
    public void shutdown() {
        for (Shutdown bean : this.beans) {
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Starting invocation before shutdown method of bean: {}", (Object)bean);
                }
                bean.before();
            }
            catch (IllegalStateException e) {
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("before: ", (Throwable)e);
            }
        }
        AtomicLong tasks = this.taskMetrics.getTasks();
        while (tasks.get() > 0L) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("Wait for {} tasks execute complete", (Object)tasks.get());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("System will shuting down...");
        }
        System.exit(0);
    }
}

