/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.eventbus;

import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractEventPark
implements EventPark,
ApplicationContextAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventPark.class);
    protected ApplicationContext applicationContext;

    protected abstract EventBus getEventBus();

    protected abstract String getEventParkName();

    @Override
    public void register(EventListener listener) {
        Method[] methods;
        EventBus eventBus = this.getEventBus();
        eventBus.register((Object)listener);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Registering listeners to {}: {}", (Object)this.getEventParkName(), (Object)listener);
        }
        boolean noSubscribeMethod = true;
        for (Method method : methods = listener.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Subscribe.class)) continue;
            noSubscribeMethod = false;
        }
        if (noSubscribeMethod) {
            throw new RuntimeException(listener.getClass() + " must have an @Subscribe method!");
        }
    }

    @Override
    public void unregister(EventListener listener) {
        this.getEventBus().unregister((Object)listener);
    }

    @Override
    public void post(EventObject eventObject) {
        this.getEventBus().post((Object)eventObject);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("EventBus post event: {}", (Object)eventObject);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Map beansOfType = this.applicationContext.getBeansOfType(EventListener.class);
        Set entries = beansOfType.entrySet();
        for (Map.Entry entry : entries) {
            this.register((EventListener)entry.getValue());
        }
    }
}

