package com.bxm.warcar.utils.file;

import java.io.File;

/**
 * @author allen
 * @since 1.0.0
 */
public final class SystemFileComparatorFactory {

    private File fingerprint;
    private File data;
    private FingerprintTracker fingerprintTracker;
    private DataTracker dataTracker;

    private SystemFileComparatorFactory() {
    }

    public static SystemFileComparatorFactory create() {
        return new SystemFileComparatorFactory();
    }

    public SystemFileComparatorFactory fingerprint(File fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    public SystemFileComparatorFactory data(File data) {
        this.data = data;
        return this;
    }

    public SystemFileComparatorFactory fingerprintTracker(FingerprintTracker fingerprintTracker) {
        this.fingerprintTracker = fingerprintTracker;
        return this;
    }

    public SystemFileComparatorFactory dataTracker(DataTracker dataTracker) {
        this.dataTracker = dataTracker;
        return this;
    }

    public SystemFileComparator build() {
        return new SystemFileComparator(fingerprint, data, fingerprintTracker, dataTracker);
    }
}
