/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.validate;

import org.apache.commons.beanutils.PropertyUtils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public abstract class CompareValidator extends AbstractValidator {

	private final Field compareField;
	private final String compareFieldName;

	public CompareValidator(Field field, Field compareField) {
		super(field);
		if (null == compareField)
			throw new NullPointerException("compareField");
		this.compareField = compareField;
		this.compareFieldName = compareField.getName();
	}

	protected Field getCompareField() {
		return compareField;
	}

	public String getCompareFieldName() {
		return compareFieldName;
	}

	protected Object getCompareValue(Object input) throws IllegalArgumentException,
			IllegalAccessException {
		try {
			return PropertyUtils.getProperty(input, compareFieldName);
		} catch (InvocationTargetException e) {
			throw new ValidateException("getTargetValue:", e);
		} catch (NoSuchMethodException e) {
			throw new ValidateException("getTargetValue:", e);
		}
	}
}
