/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.response;

import com.bxm.warcar.utils.response.ResultModel;

public final class ResultModelFactory {
    private ResultModelFactory() {
    }

    public static <T> ResultModel<T> getResultModel() {
        return ResultModel.newInstance();
    }

    public static <T> ResultModel<T> SUCCESS() {
        return ResultModelFactory.SUCCESS(null);
    }

    public static <T> ResultModel<T> SUCCESS(T returnValue) {
        return ResultModelFactory.getResultModel(returnValue, true, null, null);
    }

    public static <T> ResultModel<T> FAILED() {
        return ResultModelFactory.FAILED(ResultErrorCode.ERROR.errorCode, ResultErrorCode.ERROR.errorDesc);
    }

    public static <T> ResultModel<T> FAILED400() {
        return ResultModelFactory.FAILED(ResultErrorCode.REQUEST_ERROR.errorCode, ResultErrorCode.REQUEST_ERROR.errorDesc);
    }

    public static <T> ResultModel<T> FAILED400(String errorDesc) {
        return ResultModelFactory.FAILED(ResultErrorCode.REQUEST_ERROR.errorCode, errorDesc);
    }

    public static <T> ResultModel<T> FAILED401() {
        return ResultModelFactory.FAILED(ResultErrorCode.LOGIN_ERROR.errorCode, ResultErrorCode.LOGIN_ERROR.errorDesc);
    }

    public static <T> ResultModel<T> FAILED401(String errorDesc) {
        return ResultModelFactory.FAILED(ResultErrorCode.LOGIN_ERROR.errorCode, errorDesc);
    }

    public static <T> ResultModel<T> FAILED408() {
        return ResultModelFactory.FAILED(ResultErrorCode.TIMEOUT_ERROR.errorCode, ResultErrorCode.TIMEOUT_ERROR.errorDesc);
    }

    public static <T> ResultModel<T> FAILED408(String errorDesc) {
        return ResultModelFactory.FAILED(ResultErrorCode.TIMEOUT_ERROR.errorCode, errorDesc);
    }

    public static <T> ResultModel<T> FAILED500() {
        return ResultModelFactory.FAILED(ResultErrorCode.SYSTEM_ERROR.errorCode, ResultErrorCode.SYSTEM_ERROR.errorDesc);
    }

    public static <T> ResultModel<T> FAILED500(String errorDesc) {
        return ResultModelFactory.FAILED(ResultErrorCode.SYSTEM_ERROR.errorCode, errorDesc);
    }

    public static <T> ResultModel<T> FAILED(String errorCode, String errorDesc) {
        return ResultModelFactory.getResultModel(null, false, errorCode, errorDesc);
    }

    public static <T> ResultModel<T> getResultModel(T returnValue, boolean success, String errorCode, String errorDesc) {
        ResultModel<T> resultModel = ResultModelFactory.getResultModel();
        resultModel.setErrorCode(errorCode);
        resultModel.setErrorDesc(errorDesc);
        resultModel.setSuccessed(success);
        if (null != returnValue) {
            resultModel.setReturnValue(returnValue);
        }
        return resultModel;
    }

    public static enum ResultErrorCode {
        SUCCESS("1", "\u6210\u529f"),
        ERROR("0", "\u5931\u8d25"),
        REQUEST_ERROR("400", "the parameters error"),
        LOGIN_ERROR("401", "login error"),
        TIMEOUT_ERROR("408", "login error"),
        SYSTEM_ERROR("500", "system error");

        String errorCode;
        String errorDesc;

        private ResultErrorCode(String errorCode, String errorDesc) {
            this.errorCode = errorCode;
            this.errorDesc = errorDesc;
        }
    }
}

