/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.validate;

import com.bxm.warcar.validate.ConstraintViolationException;
import com.bxm.warcar.validate.ValidateException;
import com.bxm.warcar.validate.Validator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class AbstractValidator
implements Validator {
    private final Field field;
    private final String fieldName;
    private String defaultValue;

    public AbstractValidator(Field field) {
        if (null == field) {
            throw new NullPointerException("field");
        }
        this.field = field;
        this.fieldName = field.getName();
    }

    public AbstractValidator(Field field, String defaultValue) {
        if (null == field) {
            throw new NullPointerException("field");
        }
        this.field = field;
        this.fieldName = field.getName();
        this.defaultValue = defaultValue;
    }

    protected String getFieldDesc(Field f) {
        return new StringBuilder(64).append(f.getDeclaringClass().getName()).append(".").append(this.getField().getName()).toString();
    }

    protected String getFieldDesc() {
        return this.getFieldDesc(this.getField());
    }

    @Override
    public void validate(Object input) throws ValidateException, ConstraintViolationException {
        if (null == input) {
            throw new NullPointerException("input");
        }
        try {
            this.doValidate(input);
        }
        catch (Exception e) {
            if (e instanceof ValidateException) {
                throw (ValidateException)e;
            }
            throw new ValidateException(e);
        }
    }

    protected abstract void doValidate(Object var1) throws Exception;

    protected Object getValue(Object input) throws IllegalArgumentException, IllegalAccessException {
        try {
            return PropertyUtils.getProperty((Object)input, (String)this.fieldName);
        }
        catch (InvocationTargetException e) {
            throw new ValidateException("getValue:", e);
        }
        catch (NoSuchMethodException e) {
            throw new ValidateException("getValue:", e);
        }
    }

    protected void setValue(Object input, String value) throws IllegalArgumentException, IllegalAccessException {
        try {
            Class<?> aClass = Class.forName(this.getField().getGenericType().getTypeName());
            if (aClass.equals(String.class)) {
                PropertyUtils.setProperty((Object)input, (String)this.fieldName, (Object)value);
            } else {
                Method m = aClass.getMethod("valueOf", String.class);
                Object obj = m.invoke(aClass, value);
                PropertyUtils.setProperty((Object)input, (String)this.fieldName, (Object)obj);
            }
        }
        catch (InvocationTargetException e) {
            throw new ValidateException("setValue:", e);
        }
        catch (NoSuchMethodException e) {
            throw new ValidateException("setValue:", e);
        }
        catch (ClassNotFoundException e) {
            throw new ValidateException("setValue:", e);
        }
    }

    protected Field getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return this.getConstraintDesc();
    }
}

