/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.configure.loader.zk;

import com.bxm.warcar.configure.loader.AbstractEnvironmentLoader;
import com.bxm.warcar.configure.loader.zk.ZooKeeperHolder;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperEnvironmentLoader
extends AbstractEnvironmentLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperEnvironmentLoader.class);
    private ZooKeeperHolder zooKeeperHolder;

    public ZooKeeperEnvironmentLoader(String address, String[] keys) {
        super(address, keys);
        this.zooKeeperHolder = new ZooKeeperHolder(this.addresses);
        this.zooKeeperHolder.init();
    }

    @Override
    protected byte[] readSource(String key) {
        CuratorFramework client = this.zooKeeperHolder.getClient();
        try {
            return (byte[])client.getData().forPath(key);
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("loadProperties:", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public void destroy() {
        if (null != this.zooKeeperHolder) {
            this.zooKeeperHolder.destroy();
        }
    }
}

