/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class IpHelper {
    public static String getIpFromHeader(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String ip = request.getHeader("X-Forwarded-For");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ip) && !"unknown".equalsIgnoreCase(ip)) {
            return ip.indexOf(44) == -1 ? ip : ip.substring(0, ip.indexOf(44));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getIpNoDotTwo(String ip) {
        if (StringUtils.isBlank((String)ip)) {
            return "0";
        }
        String[] ips = ip.split("\\.");
        if (ips.length != 4) {
            return "0";
        }
        return ips[0] + ips[1];
    }

    public static String getIpNoDot(String ip) {
        if (StringUtils.isBlank((String)ip)) {
            return "0";
        }
        String[] ips = ip.split("\\.");
        if (ips.length != 4) {
            return "0";
        }
        return ip.replace(".", "");
    }

    public static int getIntIp(String ip) {
        if (StringUtils.isBlank((String)ip)) {
            return 0;
        }
        String[] ips = ip.split("\\.");
        if (ips.length != 4) {
            return 0;
        }
        return (Integer.parseInt(ips[0]) << 24) + (Integer.parseInt(ips[1]) << 16) + (Integer.parseInt(ips[2]) << 8) + Integer.parseInt(ips[3]);
    }

    public static String getStringIp(int intIp) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(intIp >>> 24));
        sb.append(".");
        sb.append(String.valueOf((intIp & 0xFFFFFF) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((intIp & 0xFFFF) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(intIp & 0xFF));
        return sb.toString();
    }
}

