package com.bxm.warcar.integration.pair.redis;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.integration.pair.DefaultValue;
import com.bxm.warcar.integration.pair.MutablePair;
import com.bxm.warcar.integration.pair.Value;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.JedisPool;

/**
 * 基于Redis的实现
 *
 * @author allen
 * @since 1.0.0
 */
public class RedisPairImpl implements MutablePair {

    private static final String DEFAULT_PAIR_KEY = "warcar:integration:pair";

    private final JedisPool jedisPool;
    private final JedisFetcher jedisFetcher;
    private final JedisUpdater jedisUpdater;
    private final String pairKey;

    public RedisPairImpl(JedisPool jedisPool) {
        this(jedisPool, DEFAULT_PAIR_KEY);
    }

    private RedisPairImpl(JedisPool jedisPool, String pairKey) {
        this.jedisPool = jedisPool;
        this.jedisFetcher = new JedisFetcher(jedisPool);
        this.jedisUpdater = new JedisUpdater(jedisPool);
        this.pairKey = pairKey;
    }

    @Override
    public Value get(String key) {
        return new DefaultValue(get0(key));
    }

    @Override
    public void set(String key, String value) {
        jedisUpdater.hupdate(() -> DEFAULT_PAIR_KEY, key, value);
    }

    @Override
    public void delete(String key) {
        jedisUpdater.hremove(() -> DEFAULT_PAIR_KEY, key);
    }

    private String get0(String key) {
        if (StringUtils.isBlank(key)) {
            return null;
        }
        return jedisFetcher.hfetch(() -> DEFAULT_PAIR_KEY, key, String.class);
    }
}
