package com.bxm.warcar.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <h3>钉钉助手</h3>
 * <p>warnDingDingToken 默认有一个值，根据配置不同，可配置其它token</p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/05/17 16:40
 */
@Deprecated
public class WarnHelper {

	private  static final String DDJobUrl = "https://oapi.dingtalk.com/robot/send?access_token=";

	private  static String warnDingDingToken = "570ebbc537233f1d6cfad4be8f884cb893b44dff6cdf91c030e95a36eb3b72eb";

	private static PoolingHttpClientConnectionManager connMgr;
	private static RequestConfig requestConfig;
	private static final int MAX_TIMEOUT = 240000;

	static {
		// 设置连接池
		connMgr = new PoolingHttpClientConnectionManager();
		// 设置连接池大小
		connMgr.setMaxTotal(100);
		connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());

		RequestConfig.Builder configBuilder = RequestConfig.custom();
		// 设置连接超时
		configBuilder.setConnectTimeout(MAX_TIMEOUT);
		// 设置读取超时
		configBuilder.setSocketTimeout(MAX_TIMEOUT);
		// 设置从连接池获取连接实例的超时
		configBuilder.setConnectionRequestTimeout(MAX_TIMEOUT);
		// 在提交请求之前 测试连接是否可用
		configBuilder.setStaleConnectionCheckEnabled(true);
		requestConfig = configBuilder.build();
	}


	/**
	 * @description 发送钉钉消息
	 * @author hcmony
	 * @time 2018/5/17
	 * @param token 钉钉群token
	 * @param content 消息内容
	 * @param isAtAll 是否@所有人
	 * @param atMobiles
	 * @return void
	 */
	public static void sendDDWarn(String token, String content, Boolean isAtAll, List<String> atMobiles){

		JSONObject jsonParam = new JSONObject();
	
		Map<String, Object> text = new HashMap<String, Object>();
		text.put("content", content);

		Map<String, Object> at = new HashMap<String, Object>();
		at.put("atMobiles", atMobiles);
		at.put("isAtAll", isAtAll);
		
		jsonParam.put("msgtype", "text");
		jsonParam.put("text", text);
		jsonParam.put("at", at);
		if(StringUtils.isNotBlank(token)){
			warnDingDingToken = token;
		}
		doPost(DDJobUrl+warnDingDingToken, jsonParam.toJSONString());
	}

	/**
	 * 发送 POST 请求（HTTP），JSON形式
	 * @param apiUrl
	 * @param json json对象
	 * @return
	 */
	public static String doPost(String apiUrl, Object json) {
		CloseableHttpClient httpClient = HttpClients.createDefault();
		String result = null;
		HttpPost httpPost = new HttpPost(apiUrl);
		CloseableHttpResponse response = null;

		try {
			httpPost.setConfig(requestConfig);
			StringEntity stringEntity = new StringEntity(json.toString(),"UTF-8");//解决中文乱码问题
			stringEntity.setContentEncoding("UTF-8");
			stringEntity.setContentType("application/json");
			httpPost.setEntity(stringEntity);
			response = httpClient.execute(httpPost);
			HttpEntity entity = response.getEntity();
			result = EntityUtils.toString(entity, "UTF-8");
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (response != null) {
				try {
					EntityUtils.consume(response.getEntity());
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return result;
	}

	public static void main(String[] args) {
		sendDDWarn(null, "我测试 下", false, null);
	}
}
